// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityFly.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityFly.h"
#include "Level.h"




EntityFly::EntityFly() 
{

  m_DisplayOffset.x = 31;
  m_DisplayOffset.y = 36;

  m_Floating  = true;
  m_Health    = 2;

  SetRect( &m_CollisionRect, -25, -27, 25, 27 );

  SetDirection( Dobbs::DIR_RIGHT );
  SetFrame( Dobbs::ANIM_FLY_L );

}



EntityFly::~EntityFly() 
{
}



void EntityFly::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_INIT:
      if ( m_ExtraData )
      {
        SetDirection( (Dobbs::DirFlags)m_ExtraData );
      }
      else
      {
        SetDirection( Dobbs::DIR_LEFT );
      }
      break;
    case EE_BLOCKED_LEFT:
      SetDirection( Dobbs::DIR_RIGHT );
      SetFrame( Dobbs::ANIM_FLY_R );
      break;
    case EE_BLOCKED_RIGHT:
      SetDirection( Dobbs::DIR_LEFT );
      SetFrame( Dobbs::ANIM_FLY_L );
      break;
    case EE_BLOCKED_TOP:
      SetDirection( Dobbs::DIR_DOWN );
      SetFrame( Dobbs::ANIM_FLY_R );
      break;
    case EE_BLOCKED_BOTTOM:
      SetDirection( Dobbs::DIR_UP );
      SetFrame( Dobbs::ANIM_FLY_L );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityFly::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );
  switch ( m_Direction )
  {
    case Dobbs::DIR_LEFT:
      Move( aLevel, -180.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
      break;
    case Dobbs::DIR_RIGHT:
      Move( aLevel, 180.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
      break;
    case Dobbs::DIR_UP:
      Move( aLevel, 0.0f, -180.0f * ElapsedTime, Dobbs::DIR_UP );
      break;
    case Dobbs::DIR_DOWN:
      Move( aLevel, 0.0f, 180.0f * ElapsedTime, Dobbs::DIR_DOWN );
      break;
  }

}